/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRBogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.nbt.CompoundTag;

public class CRBogeyRenderer {

    public static class RadialBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 3);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.RADIAL_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.RADIAL_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            RadialBogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform[] wheels = this.getTransformsFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 3);
            for (int side = -1; side < 2; ++side) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                Transform wheel = wheels[side + 1];
                ((Transform)((Transform)wheel.translate(0.0, 0.75, (double)side * 1.5)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
                RadialBogeyRenderer.finalize((Transform)wheel, (PoseStack)ms, (int)light, (VertexConsumer)vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }

    public static class HeavyweightBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 3);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.HEAVYWEIGHT_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.HEAVYWEIGHT_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            HeavyweightBogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform[] wheels = this.getTransformsFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 3);
            for (int side = -1; side < 2; ++side) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                Transform wheel = wheels[side + 1];
                ((Transform)((Transform)wheel.translate(0.0, 0.75, (double)side * 1.5)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
                HeavyweightBogeyRenderer.finalize((Transform)wheel, (PoseStack)ms, (int)light, (VertexConsumer)vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }

    public static class Y25BogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.Y25_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.Y25_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            Y25BogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform[] wheels = this.getTransformsFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                Transform wheel = wheels[(side + 1) / 2];
                ((Transform)((Transform)wheel.translate(0.0, 0.75, (double)side)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
                Y25BogeyRenderer.finalize((Transform)wheel, (PoseStack)ms, (int)light, (VertexConsumer)vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }

    public static class BlombergBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.BLOMBERG_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.BLOMBERG_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            BlombergBogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform[] wheels = this.getTransformsFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                Transform wheel = wheels[(side + 1) / 2];
                ((Transform)((Transform)wheel.translate(0.0, 0.75, (double)side)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
                BlombergBogeyRenderer.finalize((Transform)wheel, (PoseStack)ms, (int)light, (VertexConsumer)vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }

    public static class ModernBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.MODERN_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.MODERN_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            ModernBogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform[] wheels = this.getTransformsFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                Transform wheel = wheels[(side + 1) / 2];
                ((Transform)((Transform)wheel.translate(0.0, 0.75, (double)side)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
                ModernBogeyRenderer.finalize((Transform)wheel, (PoseStack)ms, (int)light, (VertexConsumer)vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }

    public static class PassengerBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.PASSENGER_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.PASSENGER_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            PassengerBogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform[] wheels = this.getTransformsFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                Transform wheel = wheels[(side + 1) / 2];
                ((Transform)((Transform)wheel.translate(0.0, 0.75, (double)side)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
                PassengerBogeyRenderer.finalize((Transform)wheel, (PoseStack)ms, (int)light, (VertexConsumer)vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }

    public static class ArchbarBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.ARCHBAR_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return BogeySizes.LARGE;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.ARCHBAR_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            ArchbarBogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform[] wheels = this.getTransformsFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                Transform wheel = wheels[(side + 1) / 2];
                ((Transform)((Transform)wheel.translate(0.0, 0.75, (double)side)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
                ArchbarBogeyRenderer.finalize((Transform)wheel, (PoseStack)ms, (int)light, (VertexConsumer)vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }

    public static class FreightBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 2);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.FREIGHT_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return BogeySizes.SMALL;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.FREIGHT_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            FreightBogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform[] wheels = this.getTransformsFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                Transform wheel = wheels[(side + 1) / 2];
                ((Transform)((Transform)wheel.translate(0.0, 0.75, (double)side)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
                FreightBogeyRenderer.finalize((Transform)wheel, (PoseStack)ms, (int)light, (VertexConsumer)vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }

    public static class CoilspringBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 1);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.COILSPRING_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return CRBogeySizes.EXTRA;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.COILSPRING_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            CoilspringBogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform bogeyWheels = (Transform)((Transform)((Transform)this.getTransformFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption).translate(0.0, 0.75, 0.0)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
            CoilspringBogeyRenderer.finalize((Transform)bogeyWheels, (PoseStack)ms, (int)light, (VertexConsumer)vb);
        }
    }

    public static class LeafspringBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 1);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.LEAFSPRING_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return BogeySizes.LARGE;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.LEAFSPRING_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            LeafspringBogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform bogeyWheels = (Transform)((Transform)((Transform)this.getTransformFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption).translate(0.0, 0.75, 0.0)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
            LeafspringBogeyRenderer.finalize((Transform)bogeyWheels, (PoseStack)ms, (int)light, (VertexConsumer)vb);
        }
    }

    public static class SingleaxleBogeyRenderer
    extends BogeyRenderer {
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, CRBlockPartials.CR_BOGEY_WHEELS, 1);
            this.createModelInstances(materialManager, new PartialModel[]{CRBlockPartials.SINGLEAXLE_FRAME});
        }

        public BogeySizes.BogeySize getSize() {
            return BogeySizes.SMALL;
        }

        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform transform = (Transform)this.getTransformFromPartial(CRBlockPartials.SINGLEAXLE_FRAME, ms, inInstancedContraption).translate(0.0, 0.3125, 0.0);
            SingleaxleBogeyRenderer.finalize((Transform)transform, (PoseStack)ms, (int)light, (VertexConsumer)vb);
            Transform bogeyWheels = (Transform)((Transform)((Transform)this.getTransformFromPartial(CRBlockPartials.CR_BOGEY_WHEELS, ms, inInstancedContraption).translate(0.0, 0.75, 0.0)).rotateX((double)wheelAngle)).translate(0.0, -0.4375, 0.0);
            SingleaxleBogeyRenderer.finalize((Transform)bogeyWheels, (PoseStack)ms, (int)light, (VertexConsumer)vb);
        }
    }
}

